/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap;

import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.Node;
import jade.core.Service;
import jade.core.UnreachableException;
import jade.imtp.leap.Command;
import jade.imtp.leap.DispatcherException;
import jade.imtp.leap.Stub;

class NodeStub
extends Stub
implements Node {
    private String name;
    private boolean hasPM = false;

    public NodeStub() {
    }

    public NodeStub(int id) {
        super(id);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasPlatformManager() {
        return this.hasPM;
    }

    void setPlatformManager(boolean b) {
        this.hasPM = b;
    }

    public void exportSlice(String serviceName, Service.Slice localSlice) {
        throw new RuntimeException("Trying to export a slice on a node stub");
    }

    public void unexportSlice(String serviceName) {
    }

    public Object accept(HorizontalCommand cmd) throws IMTPException {
        try {
            if (this.myLogger.isLoggable(4)) {
                this.myLogger.log(4, "Sending HC " + cmd.getName() + " to remote node " + this.name + " at addresses " + this.remoteTAs.toString());
            }
            Command leapCmd = new Command(8, this.remoteID);
            leapCmd.addParam(cmd);
            Command result = this.theDispatcher.dispatchCommand(this.remoteTAs, leapCmd);
            this.checkResult(result, new String[0]);
            return result.getParamAt(0);
        }
        catch (DispatcherException de) {
            throw new IMTPException("Dispatcher error", de);
        }
        catch (UnreachableException ue) {
            throw new IMTPException("Remote object unreachable", ue);
        }
    }

    public boolean ping(boolean hang) throws IMTPException {
        Command cmd = hang ? new Command(9, this.remoteID) : new Command(10, this.remoteID);
        cmd.addParam(new Boolean(hang));
        try {
            if (this.myLogger.isLoggable(5)) {
                this.myLogger.log(5, "Pinging remote node " + this.name + " at addresses " + this.remoteTAs.toString());
            }
            Command result = this.theDispatcher.dispatchCommand(this.remoteTAs, cmd);
            this.checkResult(result, new String[0]);
            Boolean b = (Boolean)result.getParamAt(0);
            if (this.myLogger.isLoggable(5)) {
                this.myLogger.log(5, "Ping to remote node " + this.name + " returned: " + b);
            }
            return b;
        }
        catch (DispatcherException de) {
            throw new IMTPException("Dispatcher error", de);
        }
        catch (UnreachableException ue) {
            throw new IMTPException("Remote object unreachable", ue);
        }
    }

    public void interrupt() throws IMTPException {
        Command cmd = new Command(12, this.remoteID);
        try {
            Command result = this.theDispatcher.dispatchCommand(this.remoteTAs, cmd);
            this.checkResult(result, new String[0]);
        }
        catch (DispatcherException de) {
            throw new IMTPException("Dispatcher error", de);
        }
        catch (UnreachableException ue) {
            throw new IMTPException("Remote object unreachable", ue);
        }
    }

    public void exit() throws IMTPException {
        Command cmd = new Command(11, this.remoteID);
        try {
            Command result = this.theDispatcher.dispatchCommand(this.remoteTAs, cmd);
            this.checkResult(result, new String[0]);
        }
        catch (DispatcherException de) {
            throw new IMTPException("Dispatcher error", de);
        }
        catch (UnreachableException ue) {
            throw new IMTPException("Remote object unreachable", ue);
        }
    }

    public void platformManagerDead(String deadPMAddress, String notifyingPMAddress) throws IMTPException {
        Command cmd = new Command(16, this.remoteID);
        cmd.addParam(deadPMAddress);
        cmd.addParam(notifyingPMAddress);
        try {
            Command result = this.theDispatcher.dispatchCommand(this.remoteTAs, cmd);
            this.checkResult(result, new String[0]);
        }
        catch (DispatcherException de) {
            throw new IMTPException("Dispatcher error", de);
        }
        catch (UnreachableException ue) {
            throw new IMTPException("Remote object unreachable", ue);
        }
    }

    public String toString() {
        String address = (this.remoteTAs != null && this.remoteTAs.size() > 0 ? this.remoteTAs.get(0) : "null").toString();
        return "[" + this.name + ", " + this.remoteID + ", " + address + "]";
    }
}

